/**
  Copyright (c) 2012 Freescale Semiconductor
  
  \file       mc_ClockTemp.c
  \brief      Clock and temperature movie clip
  \author     Freescale Semiconductor
  \author     DB, r54930
  \version    1.0
  \date       20/Mar/2013
  
  * History:  20/March/2013- Initial Version

* Copyright (c) 2008, Freescale, Inc.  All rights reserved.
*
*
* No part of this document must be reproduced in any form - including copied,
* transcribed, printed or by any electronic means - without specific written
* permission from Freescale Semiconductor.
*
   
*/

#ifndef	_MC_PARAMETERS_H_
#define	_MC_PARAMETERS_H_

#include "..\SERVICES\AnimationCtrl.h" 
#include "..\HAL\DCU_drv.h"
#include "..\HIL\Flib.h"
#include "Layers_distribution.h"        // If you need a layer in you MC make sure to mark it here

#define var32_read(addr)      (*(uint32_t *)((addr)))

#define var32_write(addr,val) (*((uint32_t *)(addr)) = (val))

#define  var32setbit(addr,bitpos) \
         var32_write((addr),(var32_read((addr)) | (1<<(bitpos))))

#define  var32clrbit(addr,bitpos) \
         var32_write((addr),(var32_read((addr)) & (0xFFFFFFFF ^ (1<<(bitpos)))))

#define  var32testbit(addr,bitpos) (((*((uint32_t *)(addr))) & (1<<(bitpos))) >> bitpos)

/*********************** def's and variables for statically allocated GRAM ***********************/
#define TABS_SAM_SIZE           0x11A0  // size of allocated mem
extern uint8_t p_tabsSAM[];              //pointer to statically allocated mem for tabs MC  
#define STAGE_TC_SAM_SIZE       0x13880   
extern uint8_t p_stage_tcSAM[];              //pointer to statically allocated mem for tabs MC
#define BASE_SAM_SIZE           (300*200)   
extern uint8_t p_baseSAM[]; 
//extern char *TextStrings[][];
extern uint8_t AutoAnimate;
extern uint8_t gas;
/************/
/*  Global Color Defines */
/************/
#define TABS_RED        0xB20000
#define TABS_ORANGE     0xFF6600
#define TABS_GREEN      0x00d600
#define TABS_BLUE       0x2020bb
#define TABS_WHITE      0xFFFFFF


/*********************** Movie Clip Base Data Section ***********************/
           
           
/*********************** TOP Data Section ***********************/


/*********************** Movie Clip Base Data Section ***********************/
typedef struct
{
    uint8_t     h;
    uint8_t     m;
    uint8_t     s;
}time_of_day_t;

typedef struct
{
    uint16_t    y;
    uint8_t     m;
    uint8_t     d;
}date_t;

typedef struct
{
    uint32_t 	example;
    uint32_t    state;
    uint32_t    pastState;
}mc_base_parameters_t;

typedef struct
{
  struct{
    uint8_t     dfl;
    uint8_t     dfr;
    uint8_t     drl;
    uint8_t     drr;
    uint8_t     boot;
    uint8_t     gas;
  }doors;
}mc_doors_parameters_t;

typedef struct
{
    uint8_t 	        function;       // The selected function = tab position
    uint8_t             subFunction;    // e.x. DVD or Radio or ... if media function selected
    uint8_t             *mmText;        //MultiMedia text pointer (assumes NULL terminated ASCII string)
    uint8_t             mmTextCount;    // amount of chars
    uint8_t             mmTextUpdate;   //Trigg the update. set by client, reset by MC.
    uint8_t             gear;           //0=P and then , R,N,D, M1 - M6
    time_of_day_t 	time;   // time of day
    int16_t             temp;           // temperature. signed 0.1 deg C resolution
    uint32_t            oddo;            //oddometer in 0,1 km 
    uint32_t            trip1;           //trip in 0,1 km      
    uint32_t            trip2;           //trip in 0,1 km
    struct
    {
      uint16_t	fl :2;		//front left
      uint16_t 	fr :2;		//front right
      uint16_t 	rl :2;		//rear left
      uint16_t 	rm :2;		//rear mid
      uint16_t 	rr :2;		//rear right
      uint16_t 	blink :1;	//blink the RED positions
      uint16_t 	res :5;	//reserv unused
    }seatBelt;    
}mc_tabs_parameters_t;

typedef struct
{
    uint8_t 	        function;       // The selected function = tab position
    uint16_t            speed;          // current speed
    uint16_t            avgSpeed;        // avereage Speed
    uint8_t             mode;           // No meaning used in the static var
    uint32_t            shortTrip;      // trip meter since we started this cycle
    uint32_t            longTrip;       // trip meter since last reset
    uint16_t            avgFuel;        // realtime consumption
    uint16_t            avgFuelAcc;     // accumulated average consumption
}mc_stage_tc_parameters_t;

typedef struct
{
    //time_of_day_t 	time;           // time of day
    date_t              date;           //date
    
    uint16_t            range;          //in km
    uint16_t            fuelLevel;      //in 0.1%
    uint16_t            fuelConsumption; //in 0.01 l/km
    uint32_t            oddo;            //oddometer in 0,1 km
    uint32_t            trip1;           //trip in 0,1 km
    uint32_t            trip2;           //trip in 0,1 km
    uint8_t             mmSource;       // MultiMedia source 0 - 10 Radio LW, MW, FM, Sirrius, DVD, JukeBox, SD1, SD2, Aux, BT
    uint8_t             units;          // 0=metric, 1=imperial
    uint8_t             lang;           // Language 0=Eng, 1=Swedish, 2 = German, 3 = Spanish
    uint16_t            speed;          // current speed
    uint16_t            rpm;          // current speed
}mc_global_parameters_t;

typedef struct
{
  uint32_t        something;

}mc_tui_test_paramters_t;

typedef struct
{
    uint16_t    mode;           //0 stand-by, 1 load, 2, auto.
    uint16_t    str_size;    
    uint16_t    move_size;
    uint16_t    data_size;      
    uint8_t     str[36];
    float       move[128];    
    uint8_t     data[4096];    
}mc_gps_parameters_t;

typedef struct
{
        int32_t		offset;				//0 is center, 100 per image it rolls over when offset is > max image
	uint16_t	bar;				//0 to 400
        uint16_t	status;	                        //0 - show play button, 1 show pause button               
	uint8_t         str[36];			//null terminated string of the song being played
        uint8_t	        print;	                        //0 do nothing, 1 - print text on str[]
}mc_cf_parameters_t;

typedef struct
{
  uint8_t       left;   //latches to 1 when pressed, user must unlatch
  uint8_t       right;  //latches to 1 when pressed, user must unlatch
  uint8_t       center; //latches to 1 when pressed, user must unlatch
  uint8_t       wheel;  //wheel goes from 0 to 255, rolls over or can go in negative direction.
}mc_input_parameters_t;

typedef struct
{
  uint16_t speed;
  uint16_t rpm;
  uint8_t  sign;
  uint8_t  mirror;
  uint8_t  dummy1;
  uint8_t  dummy2;  
}mc_hud_parameters_t;

extern mc_doors_parameters_t mc_doors_parameters;
extern mc_base_parameters_t mc_base_parameters;
extern mc_tabs_parameters_t mc_tabs_parameters;
extern mc_stage_tc_parameters_t mc_stage_tc_parameters;
extern mc_global_parameters_t mc_global_parameters;
extern mc_stage_tc_parameters_t mc_stage_tc_parameters_l;  // normally this is static but we need to make an exception here

extern mc_tui_test_paramters_t mc_tui_test_paramters;
extern mc_gps_parameters_t mc_gps_parameters;
extern mc_cf_parameters_t mc_cf_parameters;
extern mc_input_parameters_t mc_input_parameters;
extern mc_hud_parameters_t mc_hud_parameters;

/*********************** Movie Clip PROPERTIES Data Section ***********************/
extern void InitStaticMCmem(void);

extern mc_properties_t mc_base_properties;
void mc_base(uint32_t CurrentFrame);
void mc_base_Dispose(void);
void mc_base_Refresh(void);

extern mc_properties_t mc_tabs_properties;
void mc_tabs(uint32_t CurrentFrame);
void mc_tabs_Dispose(void);
void mc_tabs_Refresh(void);



extern mc_properties_t mc_doors_properties;
void mc_doors(uint32_t CurrentFrame);
void mc_doors_Dispose(void);
void mc_doors_Refresh(void);






extern mc_properties_t mc_stage_tc_properties;
void mc_stage_tc(uint32_t CurrentFrame);
void mc_stage_tc_Dispose(void);
void mc_stage_tc_Refresh(void);

extern mc_properties_t mc_base_lite_properties;
void mc_base_lite(uint32_t CurrentFrame);
void mc_base_lite_Dispose(void);
void mc_base_lite_Refresh(void);

extern mc_properties_t mc_cf_properties;
void mc_cf(uint32_t CurrentFrame);
void mc_cf_Dispose(void);
void mc_cf_Refresh(void);

extern mc_properties_t mc_video_properties;
void mc_video(uint32_t CurrentFrame);
void mc_video_Dispose(void);
void mc_video_Refresh(void);


extern mc_properties_t mc_tui_test_properties;
void mc_tui_test(uint32_t CurrentFrame);
void mc_tui_test_Dispose(void);
void mc_tui_test_Refresh(void);

extern mc_properties_t mc_gps_properties;
void mc_gps(uint32_t CurrentFrame);
void mc_gps_Dispose(void);
void mc_gps_Refresh(void);


#endif
